#!/bin/sh
clear
ifconfig eth0 down

UNIT=`cat /proc/driver/hw_detect` 
if [ "$UNIT" = "CMC-HP-BASIC" ]; then
	CRAMFS=`grep V /etc/cramfs.version`
	uname -a > /tmpfs/tmp/version
	OS=`cut -d# -f2 /tmpfs/tmp/version | cut -c1-7`
	cd /tmpfs
	mknod watchdog c 10 130

	cd /home/cmc/download
	md5sum cramfs_cmc-lcp611.img > /tmpfs/tmp/checksum2
	cd /jffs2/home/pu2
	cmp /home/cmc/download/checksum1 /tmpfs/tmp/checksum2
	if [ $? -gt 0 ]; then
		echo "no update, wrong checksum"
		echo "no update, wrong checksum" > /home/cmc/upload/update.tmp
		rm /home/cmc/upload/eraseall
		rm /home/cmc/upload/copy
	else
		if [ "$1" = "320" ]; then
			if [ "$OS" = "67 Do J" ]; then
	        	echo "No Linux/2 update needed"
	        	echo "No Linux/2 update needed" > /home/cmc/upload/update.tmp
			fi
			if [ "$CRAMFS" = "V6.11" ]; then
				echo "No cramfs update needed"
				echo "No cramfs update needed" >> /home/cmc/upload/update.tmp
				rm /home/cmc/upload/eraseall
				rm /home/cmc/upload/copy
				rm /home/cmc/download/cramfs_cmc-lcp611.img
			fi
		else 
			if [ "$OS" = "41 Do M" ]; then
				echo "No Linux/1 update needed"
				echo "No Linux/1 update needed" > /home/cmc/upload/update.tmp
		    else	
				echo "Updating Linux.."
				chmod +x /home/cmc/upload/eraseall
				/home/cmc/upload/eraseall /dev/mtd2
				echo "Copying files.."
				cp /home/cmc/download/uImage_cmc-pu2_2009-03-19_i2c_soft_thw /dev/mtd2
				echo "Linux #41 Do Mr 19 11:05:00 CET 2009" > /home/cmc/upload/update.tmp
			fi

			if [ "$CRAMFS" = "V6.11" ]; then
		       	echo "Check cramfs (V6.11, checksum)"	
				md5sum /dev/mtd3 > /tmpfs/tmp/check_cramfs2
				cmp /home/cmc/download/check_cramfs1 /tmpfs/tmp/check_cramfs2
				if [ $? -gt 0 ]; then
					echo "cramfs update required, wrong checksum"
					more /home/cmc/download/check_cramfs1
					more /tmpfs/tmp/check_cramfs2
					CRAMFS=update_required
				fi
				echo $CRAMFS
			fi

			if [ "$CRAMFS" = "V6.11" ]; then
				echo "No cramfs update needed"
				echo "No cramfs update needed" >> /home/cmc/upload/update.tmp
				rm /home/cmc/upload/eraseall
				rm /home/cmc/upload/copy
				rm /home/cmc/download/cramfs_cmc-lcp611.img
			else
				killall ftpd
				cd /home/cmc/download
				chmod +x /home/cmc/upload/eraseall
				chmod +x /home/cmc/download/reboot
				chmod +x /home/cmc/upload/copy
	
			    rm /home/cmc/download/uImage_cmc-pu2_2009-03-19_i2c_soft_thw

				echo "Updating cramfs.."
				echo "cramfs V6.11" >> /home/cmc/upload/update.tmp
				killall appWeb
				killall display
				killall eeprom
				killall lcp
				killall menu
				killall sensors
				killall smtp
				killall snmpd
				killall cmc_main
				/home/cmc/upload/eraseall /dev/mtd3
				echo "Copying files.., please wait.., do not switch off unit"
				/home/cmc/upload/copy /home/cmc/download/cramfs_cmc-lcp611.img
				rm /home/cmc/upload/eraseall
				rm /home/cmc/upload/copy
				/home/cmc/download/reboot -n -f
			fi
		fi
	fi
else
	rm /home/cmc/upload/eraseall
	rm /home/cmc/upload/copy
	echo "Update not matching for Unit, no Basic-CMC"
	echo "Update not matching, no Basic-CMC" > /home/cmc/upload/update.tmp

fi	